<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\Entity;

use Doctrine\Common\Collections\Collection;

/**
 * Trait used to get meta values from a collection of meta entities.
 *
 * The {@see self::getMetaValue()} method is used to get the value of a meta key from the collection of meta entities.
 *
 * @template T of AbstractMeta
 * @property Collection<T> $meta
 */
trait GetMetaValueTrait
{

    /**
     * @param string $key
     * @return mixed
     */
    public function getMetaValue(string $key): mixed
    {
        return $this->meta->findFirst(fn($idx, AbstractMeta $meta) => $meta->getKey() === $key)?->getValueDeserialized();
    }

}