<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * Entity mapping for the WordPress termmeta table
 *
 * This entity uses {@see AbstractMeta} as a base class for generic meta table mapping.
 */
#[
    ORM\Table('termmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Index(['term_id'], name: 'term_id'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_termmeta'),
]
class TermMeta extends AbstractMeta
{

    #[ORM\ManyToOne(targetEntity: Term::class, inversedBy: 'meta'), ORM\JoinColumn('term_id', referencedColumnName: 'term_id')]
    #[Groups(['read_meta_details'])]
    private Term $term;


    public function getTerm(): Term
    {
        return $this->term;
    }

    public function setTerm(Term $term): TermMeta
    {
        $this->term = $term;
        return $this;
    }

    public static function getType(): string
    {
        return 'term';
    }

}
