<?php

namespace WordpressModels\DependencyInjection\Initializer;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class InitializerCompilerPass implements CompilerPassInterface
{


    public function process(ContainerBuilder $container)
    {
        $initializer = $container->getDefinition(ServiceInitializer::class);
        $services = $container->findTaggedServiceIds('force_initialize');

        foreach ($services as $id => $tags) {
            $initializer->addMethodCall('addService', [$id]);
        }
    }
}