<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Attribute\Context;
use Symfony\Component\Serializer\Attribute\Groups;

/**
 * Entity mapping for the WordPress postmeta table
 *
 * This entity uses {@see AbstractMeta} as a base class for generic meta table mapping.
 */
#[
    ORM\Table('postmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_postmeta'),
]
class PostMeta extends AbstractMeta
{

    #[ORM\ManyToOne(targetEntity: Post::class, inversedBy: 'meta'), ORM\JoinColumn('post_id', referencedColumnName: 'ID')]
    #[Context(normalizationContext: ['groups' => ['read_post']])]
    #[Groups(['read_meta_details'])]
    private Post $post;

    public function getPost(): Post
    {
        return $this->post;
    }

    /**
     * @param Post $post
     */
    public function setPost(Post $post): void
    {
        $this->post = $post;
    }

    public static function getType(): string
    {
        return 'post';
    }

}
