<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\Command;

use WordpressModels\ORM\EntityManagerFactory;

class DoctrineCommand
{

    public function __construct()
    {
        add_action('cli_init', [$this, 'registerWpCliCommand']);
    }

    public function registerWpCliCommand()
    {
        $commandBridge = new DoctrineCommands(EntityManagerFactory::instance());
        \WP_CLI::add_command('doctrine dump-entities', [$commandBridge, 'dump_entities']);
        \WP_CLI::add_command('doctrine dump-schema', [$commandBridge, 'dump_migration']);
        \WP_CLI::add_command('doctrine generate-proxies', [$commandBridge, 'generate_proxies']);
        \WP_CLI::add_command('doctrine purge-proxies', [$commandBridge, 'purge_proxies']);

        // migration commands
        // review
        \WP_CLI::add_command('doctrine review', [$commandBridge, 'review']);

        // execute
        \WP_CLI::add_command('doctrine migrate', [$commandBridge, 'migrate']);
    }


}
