<?php
/**
 * Plugin Name: RTM WordPress Models (Working Title)
 * Description: Must use plugin to add extended functionality to the WordPress framework, providing Doctrine integration and more!
 * Author: RTM Business
 * Version: __PLUGIN_VERSION__
 */

use Psr\Container\ContainerInterface;
use WordpressModels\WordpressPluginContainers;
use WordpressModelsPlugin\DependencyInjection\ContainerExtensions;

if (!class_exists('WordpressModels\WordpressPluginContainers')) {
    require_once __DIR__ . '/vendor/autoload.php';
}


define('WPM_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WPM_PLUGIN_URL', plugin_dir_url(__FILE__));

define('WPM_PLUGIN_VERSION', '__PLUGIN_VERSION__');

// directory locations
define('WPM_CONTAINER_CACHE_DIR', WPM_PLUGIN_DIR . '/cache');
/**
 * Convenience function to get the global container.
 *
 * @return ContainerInterface
 */
function wpm_container(): ContainerInterface
{
    global $wpmc;
    $wpm_container = $wpmc->getContainer();

    return $wpm_container;
}

/**
 * Invalidate the global container.
 *
 * Deletes the container cache file.
 *
 * @return void
 */
function _wpm_invalidate_container(): void
{
    global $wpmc;
    $wpmc->invalidate();
}

if (is_admin()) {
    // add admin script enqueue hook for specific pages
    add_action('admin_enqueue_scripts', function ($hook_suffix) {
        global $typenow;

        // add hook for all admin pages
        do_action("admin_enqueue_scripts-{$hook_suffix}");

        // add hook for specific post type
        if ($typenow) {
            do_action("admin_enqueue_scripts-{$hook_suffix}/{$typenow}");
        }
    }, 0);
}

global $wpmc;

// if we're not executing tests, we will build the container
if (!defined('WPM_TESTING') || !WPM_TESTING) {
    $wpmc = new WordpressPluginContainers();
    ContainerExtensions::instance();
}
