<?php

namespace WordpressModelsPlugin\DependencyInjection\FederatedPages;

use WordpressModels\Page\AbstractPage;

trait FederatedPageTrait
{

    protected AbstractPage $inner;

    public function buildContext(array $parameters = []): array
    {
        return $this->inner->buildContext($parameters);
    }

    public function renderPage(): void
    {
        echo "<div id='root' class='fpa-page'></div>";
    }

    public function init(): void
    {
        $this->inner->init();
    }

    public function enqueueScripts(): void
    {
        $this->inner->enqueueScripts();
    }

    public function doEnqueue(): void
    {
        $this->inner->doEnqueue();

        // dequeue the default script
        wp_dequeue_script($this->inner->getPageId());
    }

    public function getPageId(): string
    {
        return $this->inner->getPageId();
    }

    public function getParent(): string
    {
        return $this->inner->getParent();
    }

    public function getMenuSlug(): string
    {
        return $this->inner->getMenuSlug();
    }

    public function getCapability(): string
    {
        return $this->inner->getCapability();
    }

    public function getTitle(): string
    {
        return $this->inner->getTitle();
    }

    public function getPosition(): float|int|null
    {
        return $this->inner->getPosition();
    }

    public function getIcon(): string
    {
        return $this->inner->getIcon();
    }

    public function getRenderCallback(): string|array|\Closure
    {
        return $this->inner->getRenderCallback();
    }

    public function getUrl(): string
    {
        return $this->inner->getUrl();
    }

    public function getScriptUrl(): ?string
    {
        return $this->inner->getScriptUrl();
    }

    public function addRoute(AbstractPage $page, bool $isSubPage = true): void
    {
        $this->inner->addRoute($page, $isSubPage);
    }

    public function getRouteUrl(string $route): string
    {
        return $this->inner->getRouteUrl($route);
    }

    protected function setParent(AbstractPage|string $parent): void
    {
        $this->inner->setParent($parent);
    }

    protected function setRenderCallback(string|array|\Closure $renderCallback): void
    {
        $this->inner->setRenderCallback($renderCallback);
    }

    protected function setAdditionalScripts(array $additionalScripts): void
    {
        $this->inner->setAdditionalScripts($additionalScripts);
    }

    protected function setMenuSlug(string $menuSlug): void
    {
        $this->inner->setMenuSlug($menuSlug);
    }


}