<?php

namespace WordpressModelsPlugin\DependencyInjection\FederatedPages;

use WordpressModels\Page\AbstractPage;
use WordpressModels\Page\AbstractPageStack;
use WordpressModels\Page\PageInterface;

/**
 * Decorator for AbstractPage to provide federated plugin app functionality.
 */
class FederatedPageStack extends AbstractPageStack implements PageInterface
{

    use FederatedPageTrait;

    public function __construct(AbstractPageStack $inner)
    {
        $this->inner = $inner;
        parent::__construct(
            pageId: $inner->pageId,
            menuSlug: $inner->menuSlug,
            title: $inner->title,
            parent: $inner->parent,
            capability: $inner->capability,
            position: $inner->position,
            icon: $inner->icon,
            additionalScripts: $inner->additionalScripts,
            assets: $inner->assets
        );
    }

    public function renderPage(): void
    {
        echo "<div id='root' class='fpa-page'></div>";
    }

    public function getRouteUrl(string $route): string
    {
        return $this->inner->getRouteUrl($route);
    }

    public function addRoute(AbstractPage $page, bool $isSubPage = true): void
    {
        $this->inner->addRoute($page, $isSubPage);
    }

    public function doEnqueue(): void
    {
        $this->inner->doEnqueue();
    }

    public function getUrl(): string
    {
        return $this->inner->getUrl();
    }

    public function getPages(): array
    {
        return $this->inner->getPages();
    }

}