<?php

namespace WordpressModelsPlugin\DependencyInjection\FederatedPages;

use WordpressModels\Page\AbstractPage;
use WordpressModels\Page\PageInterface;

/**
 * Decorator for AbstractPage to provide federated plugin app functionality.
 */
class FederatedPage extends AbstractPage implements PageInterface
{

    use FederatedPageTrait;

    public function __construct(AbstractPage $inner)
    {
        $this->inner = $inner;

        parent::__construct(
            pageId: $inner->pageId,
            menuSlug: $inner->menuSlug,
            title: $inner->title,
            parent: $inner->parent,
            capability: $inner->capability,
            position: $inner->position,
            icon: $inner->icon,
            additionalScripts: $inner->additionalScripts,
            assets: $inner->assets
        );
    }

}