<?php

use Doctrine\ORM\Configuration;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;
use Symfony\Component\HttpFoundation\Request;
use WordpressModels\DependencyInjection\CliCommandAttributes\WpCliCommandRegistry;
use WordpressModels\DependencyInjection\HookAttributes\ContainerHookRegistry;
use WordpressModels\DependencyInjection\Initializer\ServiceInitializer;
use WordpressModels\DependencyInjection\Metabox\MetaboxRegistry;
use WordpressModels\DependencyInjection\RestRouteAttributes\RestRouteInitializer;
use WordpressModels\DependencyInjection\RestRouteAttributes\RestRouteRegistry;
use WordpressModels\ORM\EntityManagerFactory;
use function Symfony\Component\DependencyInjection\Loader\Configurator\service;

return static function (ContainerConfigurator $container) {
    $container->parameters()
        ->set('kernel.debug', WP_DEBUG);

    $servicesConfigurator = $container->services();

    // autoconfigure and autowire all services by default
    $servicesConfigurator->defaults()
        ->autowire()
        ->autoconfigure();

    // register hook attribute service
    $servicesConfigurator->set(ContainerHookRegistry::class, ContainerHookRegistry::class)
        ->public()
        ->autowire(false);

    // register rest route attribute services
    $servicesConfigurator->set(RestRouteRegistry::class, RestRouteRegistry::class)
        ->public()
        ->autowire(false);
    $servicesConfigurator->set(RestRouteInitializer::class, RestRouteInitializer::class)
        ->public()
        ->autowire();

    // metabox
    $servicesConfigurator->set(MetaboxRegistry::class, MetaboxRegistry::class)
        ->public()
        ->args([service('service_container')]);

    // service initializer
    $servicesConfigurator->set(ServiceInitializer::class, ServiceInitializer::class)
        ->public()
        ->args([service('service_container')]);

    $servicesConfigurator->set(EntityManagerFactory::class, EntityManagerFactory::class)
        ->public()
        ->args([service('service_container')]);

    // register the entity manager configuration and manager itself
    $servicesConfigurator->set('doctrine.orm.entity_manager.config', Configuration::class)
        ->public()
        ->factory([service(EntityManagerFactory::class), 'createConfiguration'])
        ->args(['default'])
        ->autowire(false);

    $servicesConfigurator->set(WpCliCommandRegistry::class, WpCliCommandRegistry::class)
        ->public()
        ->autowire(false);

    // Add the Container Command
    $servicesConfigurator->set(\WordpressModels\Command\ContainerCommands::class, \WordpressModels\Command\ContainerCommands::class)
        ->public()
        ->autowire();

    $container->parameters()
        ->set('doctrine.default_entity_manager', 'default');

    $servicesConfigurator->set('doctrine.orm.default_entity_listener_resolver', \Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver::class)
        ->public()
        ->args([service('service_container')])
        ->alias(\Doctrine\Bundle\DoctrineBundle\Mapping\ContainerEntityListenerResolver::class, 'doctrine.orm.default_entity_listener_resolver')
        ->public();
    $servicesConfigurator->set('doctrine.orm.default_entity_manager', EntityManagerInterface::class)
        ->public()
        ->factory([service(EntityManagerFactory::class), 'create'])
        ->args([service('doctrine.orm.entity_manager.config')])
        ->autowire(false)
        ->alias(EntityManagerInterface::class, 'doctrine.orm.default_entity_manager');

    $servicesConfigurator->set(Request::class, Request::class)
        ->factory([null, 'createFromGlobals'])
        ->public();

};