<?php

namespace WordpressModels\Traits;

/**
 * Adds singleton support for all subclasses of a abstract class.
 */
trait AbstractSingletonTrait
{
    private static array $instances = [];

    public static function instance(): static
    {
        if (!isset(static::$instances[static::class])) {
            static::$instances[static::class] = new static();
        }

        return static::$instances[static::class];
    }

}