<?php

namespace WordpressModels\Rest\Permissions;

use Symfony\Component\ExpressionLanguage\ExpressionFunction;
use Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class CapabilityExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compile(string $value): string
    {
        $class = $this->permissionFunctions::class;
        return "$class::userHasCapability('$value')";
    }

    public function evaluate($args, string $capability): bool
    {
        return $this->permissionFunctions::userHasCapability($capability);
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('capability', $this->compile(...), $this->evaluate(...)),
        ];
    }
}