<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpPostmeta
 */
#[
    ORM\Table('postmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_postmeta'),
]
class PostMeta extends AbstractMeta
{

    #[ORM\ManyToOne(targetEntity: Post::class, inversedBy: 'meta'), ORM\JoinColumn('post_id', referencedColumnName: 'ID')]
    #[MaxDepth(1)]
    private Post $post;

    public function getPost(): Post
    {
        return $this->post;
    }

    /**
     * @param Post $post
     */
    public function setPost(Post $post): void
    {
        $this->post = $post;
    }


}
