<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpCommentmeta
 */
#[
    ORM\Table('commentmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_commentmeta'),
]
class CommentMeta extends AbstractMeta
{

    #[
        ORM\ManyToOne(targetEntity: Comment::class, inversedBy: 'meta'),
        ORM\JoinColumn('comment_id', referencedColumnName: 'comment_ID')
    ]
    #[MaxDepth(1)]
    private Comment $comment;


    public function getComment(): Comment
    {
        return $this->comment;
    }

    public function setComment(Comment $comment): CommentMeta
    {
        $this->comment = $comment;
        return $this;
    }

}
