<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

/**
 * WpOptions
 */
#[
    ORM\Table('options'),
    ORM\Index(['autoload'], name: 'autoload'),
    ORM\UniqueConstraint(name: 'option_name', columns: ['option_name']),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_options'),
]
class Option
{

    #[ORM\Column(name: 'option_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'option_name', type: Types::STRING, length: 191)]
    private string $name = '';

    /**
     * @var string
     */
    #[ORM\Column(name: 'option_value', type: Types::TEXT, length: 0)]
    private ?string $value = null;

    /**
     * @todo: ENUM [yes, no]
     */
    #[ORM\Column(name: 'autoload', type: Types::STRING, length: 20, options: ['default' => 'yes'])]
    private string $autoload = 'yes';

    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(?string $id): Option
    {
        $this->id = $id;
        return $this;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): Option
    {
        $this->name = $name;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): Option
    {
        $this->value = $value;
        return $this;
    }

    public function getAutoload(): string
    {
        return $this->autoload;
    }

    public function setAutoload(string $autoload): Option
    {
        $this->autoload = $autoload;
        return $this;
    }

}
