<?php

namespace WordpressModels\DependencyInjection\Metabox\Attributes;

use Attribute;

/**
 * Attribute to register a metabox.
 */
#[Attribute(Attribute::TARGET_CLASS | Attribute::IS_REPEATABLE)]
class AsMetabox
{

    public function __construct(
        public string $id,
        public string $title,
        public string $context = 'normal',
        public string $priority = 'default',
        public string|null $postType = null,
    ) {
    }

}