<?php

namespace WordpressModels\DependencyInjection\HookAttributes;

/**
 * Registry for hooks.
 *
 * At compile time, the hooks added to this registry. The {@see ContainerHookRegistry::registerHooks()} method
 * is called on 'plugins_loaded' to register the hooks.
 */
class ContainerHookRegistry
{

    /**
     * @var array{
     *     type: string,
     *     hook: string,
     *     callback: string,
     *     priority: int,
     *     accepted_args: int
     * }[]
     */
    private array $hooks = [];

    public function __construct()
    {
    }

    public function registerHooks()
    {
        foreach ($this->hooks as $action) {
            call_user_func('add_' . $action['type'],
                $action['hook'],
                $action['callback'],
                $action['priority'],
                $action['accepted_args']);
        }
    }


    public function addHook(string $id, string $type, callable $callback, string $hook, int $priority = 10, int $accepted_args = 1)
    {
        $this->hooks[] = [
            'type' => $type,
            'hook' => $hook,
            'callback' => $callback,
            'priority' => $priority,
            'accepted_args' => $accepted_args
        ];
    }

    public function addAjaxHook(string $action, bool $admin, bool $unauthenticated, int $priority, ?string $nonceId, string $nonceKey, callable $handler)
    {
        if ($admin) {
            $this->hooks[] = [
                'type' => 'action',
                'hook' => "wp_ajax_$action",
                'callback' => new AjaxActionWrapper($handler, $nonceId, $nonceKey),
                'priority' => $priority,
                'accepted_args' => 0
            ];
        }

        if ($unauthenticated) {
            $this->hooks[] = [
                'type' => 'action',
                'hook' => "wp_ajax_nopriv_$action",
                'callback' => new AjaxActionWrapper($handler, $nonceId, $nonceKey),
                'priority' => $priority,
                'accepted_args' => 0
            ];
        }
    }

}