<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * WpTermmeta
 */
#[
    ORM\Table('termmeta'),
    ORM\Index(['meta_key'], name: 'meta_key'),
    ORM\Index(['term_id'], name: 'term_id'),
    ORM\Entity,
    ORM\Cache(usage: 'NONSTRICT_READ_WRITE', region: 'wp_termmeta'),
]
class TermMeta
{

    #[ORM\Column(name: 'meta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    #[Groups(['read_term', 'read_term_meta'])]
    private ?int $id = null;

    #[ORM\ManyToOne(targetEntity: Term::class, inversedBy: 'meta'), ORM\JoinColumn('term_id', referencedColumnName: 'term_id')]
    #[Groups(['read_term_meta'])]
    private Term $term;

    #[ORM\Column(name: 'meta_key', type: Types::STRING, length: 255, nullable: true)]
    #[Groups(['read_term', 'read_term_meta'])]
    private ?string $key = null;

    #[ORM\Column(name: 'meta_value', type: Types::TEXT, length: 0, nullable: true)]
    #[Groups(['read_term', 'read_term_meta'])]
    private ?string $value = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): TermMeta
    {
        $this->id = $id;
        return $this;
    }

    public function getTerm(): Term
    {
        return $this->term;
    }

    public function setTerm(Term $term): TermMeta
    {
        $this->term = $term;
        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(?string $key): TermMeta
    {
        $this->key = $key;
        return $this;
    }

    public function getValue(): ?string
    {
        return $this->value;
    }

    public function setValue(?string $value): TermMeta
    {
        $this->value = $value;
        return $this;
    }

}
