<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpUsermeta
 */
#[ORM\Table('usermeta')]
#[ORM\Index(['meta_key'], name: 'meta_key')]
#[ORM\Entity]
class UserMeta extends AbstractMeta
{

    /**
     * Override the default column name for.
     *
     * @var int|null
     */
    #[ORM\Column(name: 'umeta_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    protected ?int $id = null;

    #[
        ORM\ManyToOne(targetEntity: User::class, inversedBy: 'meta'),
        ORM\JoinColumn('user_id', referencedColumnName: 'ID')
    ]
    #[MaxDepth(1)]
    private User $user;

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(User $user): UserMeta
    {
        $this->user = $user;
        return $this;
    }

}
