<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\Command;

class DoctrineCommand
{

    public function __construct()
    {
        add_action('cli_init', [$this, 'registerWpCliCommand']);
    }

    public function registerWpCliCommand()
    {
        \WP_CLI::add_command('doctrine dump-entities', [DoctrineCommandBridge::instance(), 'dump_entities']);
        \WP_CLI::add_command('doctrine dump-schema', [DoctrineCommandBridge::instance(), 'dump_migration']);
        \WP_CLI::add_command('doctrine generate-proxies', [DoctrineCommandBridge::instance(), 'generate_proxies']);
        \WP_CLI::add_command('doctrine purge-proxies', [DoctrineCommandBridge::instance(), 'purge_proxies']);

        // migration commands
        // review
        \WP_CLI::add_command('doctrine review', [DoctrineCommandBridge::instance(), 'review']);

        // execute
        \WP_CLI::add_command('doctrine migrate', [DoctrineCommandBridge::instance(), 'migrate']);
    }


}
