<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Serializer\Annotation\MaxDepth;

/**
 * WpTermRelationships
 */
#[ORM\Table('term_relationships')]
#[ORM\Entity]
class TermRelationship
{
    #[
        ORM\ManyToOne(targetEntity: Post::class, fetch: 'EAGER', inversedBy: 'termRelationships'),
        ORM\JoinColumn('object_id', referencedColumnName: 'ID')
    ]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'NONE')]
    #[Groups(['term_relationship'])]
    #[MaxDepth(1)]
    private ?Post $object = null;

    #[
        ORM\ManyToOne(targetEntity: TermTaxonomy::class, fetch: 'EAGER', inversedBy: 'termRelationships'),
        ORM\JoinColumn('term_taxonomy_id', referencedColumnName: 'term_taxonomy_id')
    ]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'NONE')]
    #[Groups(['term_relationship'])]
    #[MaxDepth(1)]
    private ?TermTaxonomy $termTaxonomy = null;

    #[ORM\Column(name: 'term_order', type: Types::INTEGER)]
    private int $order = 0;

    public function getObject(): ?Post
    {
        return $this->object;
    }

    public function setObject(?Post $object): TermRelationship
    {
        $this->object = $object;
        return $this;
    }

    public function getTermTaxonomy(): ?TermTaxonomy
    {
        return $this->termTaxonomy;
    }

    public function setTermTaxonomy(?TermTaxonomy $termTaxonomy): TermRelationship
    {
        $this->termTaxonomy = $termTaxonomy;
        return $this;
    }

    public function getOrder(): int
    {
        return $this->order;
    }

    public function setOrder(int $order): TermRelationship
    {
        $this->order = $order;
        return $this;
    }

}
