<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM\WooCommerceEntity;

use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\JoinColumn;
use Doctrine\ORM\Mapping\ManyToOne;
use Doctrine\ORM\Mapping\Table;
use WordpressModels\ORM\Entity\AbstractMeta;

#[Entity]
#[Table(name: 'payment_tokenmeta')]
class PaymentTokenMeta extends AbstractMeta
{

    #[ManyToOne(targetEntity: PaymentToken::class)]
    #[JoinColumn(name: 'payment_token_id', referencedColumnName: 'token_id')]
    private PaymentToken $paymentToken;

    /**
     * @return PaymentToken
     */
    public function getPaymentToken(): PaymentToken
    {
        return $this->paymentToken;
    }

    /**
     * @param PaymentToken $paymentToken
     * @return PaymentTokenMeta
     */
    public function setPaymentToken(PaymentToken $paymentToken): PaymentTokenMeta
    {
        $this->paymentToken = $paymentToken;
        return $this;
    }

    public static function getType(): string
    {
        return 'payment_token';
    }

}