<?php
/*
 * Copyright (c) 2023. RTM Business
 */

namespace WordpressModels\ORM;

use WordpressModels\ORM\WooCommerceEntity\AdminNote;
use WordpressModels\ORM\WooCommerceEntity\AdminNoteAction;
use WordpressModels\ORM\WooCommerceEntity\ApiKey;
use WordpressModels\ORM\WooCommerceEntity\AttributeTaxonomy;
use WordpressModels\ORM\WooCommerceEntity\DownloadableProductPermission;
use WordpressModels\ORM\WooCommerceEntity\Log;
use WordpressModels\ORM\WooCommerceEntity\OrderItem;
use WordpressModels\ORM\WooCommerceEntity\OrderItemMeta;
use WordpressModels\ORM\WooCommerceEntity\PaymentToken;
use WordpressModels\ORM\WooCommerceEntity\PaymentTokenMeta;
use WordpressModels\ORM\WooCommerceEntity\PostType\Product;
use WordpressModels\ORM\WooCommerceEntity\PostType\ShopOrder;
use WordpressModels\ORM\WooCommerceEntity\Session;
use WordpressModels\ORM\WooCommerceEntity\ShippingZone;
use WordpressModels\ORM\WooCommerceEntity\ShippingZoneMethods;
use WordpressModels\ORM\WooCommerceEntity\TaxRate;
use WordpressModels\ORM\WooCommerceEntity\TaxRateLocation;
use WordpressModels\Traits\SingletonTrait;

class WooCommerceEntities
{

    use SingletonTrait;

    public function __construct()
    {
        add_filter('doctrine_entity_directories', $this->addEntityDirectories(...));
        add_filter('doctrine_post_type_discriminator_map', $this->addPostTypeDiscriminators(...));
        add_filter('doctrine_plugin_entity_table_prefixes', $this->setWoocommercePrefixes(...));
    }

    public function addEntityDirectories(array $directories): array
    {
        return [...$directories, realpath(__DIR__ . '/WooCommerceEntity')];
    }

    public function addPostTypeDiscriminators(array $classMap): array
    {
        return $classMap + [
                'product' => Product::class,
                'shop_order' => ShopOrder::class
            ];
    }

    /**
     * Set the prefixes for WooCommerce entities.
     *
     * @param array $classMap
     * @return array
     */
    public function setWoocommercePrefixes(array $classMap): array
    {
        $longPrefixEntities = [
            ApiKey::class,
            AttributeTaxonomy::class,
            DownloadableProductPermission::class,
            Log::class,
            OrderItem::class,
            OrderItemMeta::class,
            PaymentToken::class,
            PaymentTokenMeta::class,
            Session::class,
            ShippingZone::class,
            ShippingZoneMethods::class,
            TaxRate::class,
            TaxRateLocation::class
        ];
        foreach ($longPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'woocommerce';
        }

        $shortPrefixEntities = [
            AdminNote::class,
            AdminNoteAction::class,
        ];

        foreach ($shortPrefixEntities as $entityClass) {
            $classMap[$entityClass] = 'wc';
        }

        return $classMap;
    }

}
