<?php

namespace WordpressModels\ORM\Entity;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Attribute\Context;
use Symfony\Component\Serializer\Attribute\Groups;

/**
 * Entity mapping for the WordPress term_relationships table
 *
 * This entity is a association table between the term_taxonomy and the post table. It is used to store the relationship
 * between a term and a post and the taxonomy of the term.
 */
#[ORM\Table('term_relationships')]
#[ORM\Entity]
class TermRelationship
{
    #[
        ORM\ManyToOne(targetEntity: Post::class, fetch: 'EAGER', inversedBy: 'termRelationships'),
        ORM\JoinColumn('object_id', referencedColumnName: 'ID')
    ]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'NONE')]
    #[Groups(['read_term_relationship_post'])]
    private ?Post $object = null;

    #[
        ORM\ManyToOne(targetEntity: TermTaxonomy::class, fetch: 'EAGER', inversedBy: 'termRelationships'),
        ORM\JoinColumn('term_taxonomy_id', referencedColumnName: 'term_taxonomy_id')
    ]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'NONE')]
    #[Groups(['read_term_relationship'])]
    private ?TermTaxonomy $termTaxonomy = null;

    #[ORM\Column(name: 'term_order', type: Types::INTEGER)]
    #[Groups(['read_term_relationship'])]
    private int $order = 0;

    public function getObject(): ?Post
    {
        return $this->object;
    }

    public function setObject(?Post $object): TermRelationship
    {
        $this->object = $object;
        return $this;
    }

    public function getTermTaxonomy(): ?TermTaxonomy
    {
        return $this->termTaxonomy;
    }

    public function setTermTaxonomy(?TermTaxonomy $termTaxonomy): TermRelationship
    {
        $this->termTaxonomy = $termTaxonomy;
        return $this;
    }

    public function getOrder(): int
    {
        return $this->order;
    }

    public function setOrder(int $order): TermRelationship
    {
        $this->order = $order;
        return $this;
    }

}
