<?php

namespace WordpressModels\DependencyInjection\Initializer;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Extension\Extension;
use WordpressModels\DependencyInjection\Initializer\Attributes\ForceInitialize;

class InitializerExtension extends Extension
{


    public function load(array $configs, ContainerBuilder $container)
    {
        $container->registerAttributeForAutoconfiguration(ForceInitialize::class, self::tagForceInitialize(...));

        // register the service initializer
        $container->register(ServiceInitializer::class)
            ->setPublic(true)
            ->setAutowired(true)
            ->setAutoconfigured(true);
    }

    public static function tagForceInitialize(Definition $definition): void
    {
        // prevent auto-removal due to the service being private
        $definition->setPublic(true);
        // set non-lazy
        $definition->setLazy(false);

        // tag the service
        $definition->addTag('force_initialize');
    }

}