<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Symfony\Bridge\Doctrine\SchemaListener;

use WRCE\Dependencies\Doctrine\ORM\Tools\Event\GenerateSchemaEventArgs;
use Symfony\Component\Lock\Exception\InvalidArgumentException;
use Symfony\Component\Lock\PersistingStoreInterface;
use Symfony\Component\Lock\Store\DoctrineDbalStore;

final class LockStoreSchemaListener extends AbstractSchemaListener
{
    /**
     * @param iterable<mixed, PersistingStoreInterface> $stores
     */
    public function __construct(
        private readonly iterable $stores,
    ) {
    }

    public function postGenerateSchema(GenerateSchemaEventArgs $event): void
    {
        $connection = $event->getEntityManager()->getConnection();

        $storesIterator = new \ArrayIterator($this->stores);
        while ($storesIterator->valid()) {
            try {
                $store = $storesIterator->current();
                if (!$store instanceof DoctrineDbalStore) {
                    continue;
                }

                $store->configureSchema($event->getSchema(), $this->getIsSameDatabaseChecker($connection));
            } catch (InvalidArgumentException) {
                // no-op
            }

            $storesIterator->next();
        }
    }
}
