<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\Persistence\Mapping;

use WRCE\Dependencies\Doctrine\Persistence\Proxy;

interface ProxyClassNameResolver
{
    /**
     * @psalm-param class-string<Proxy<T>>|class-string<T> $className
     *
     * @psalm-return class-string<T>
     *
     * @template T of object
     */
    public function resolveClassName(string $className): string;
}
