<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Utility;

use WRCE\Dependencies\Doctrine\DBAL\Platforms\AbstractMySQLPlatform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\AbstractPlatform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\DB2Platform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\MySQLPlatform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\PostgreSQLPlatform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\SqlitePlatform;
use WRCE\Dependencies\Doctrine\DBAL\Platforms\SQLServerPlatform;

/** @internal */
trait LockSqlHelper
{
    private function getReadLockSQL(AbstractPlatform $platform): string
    {
        if ($platform instanceof AbstractMySQLPlatform || $platform instanceof MySQLPlatform) {
            return 'LOCK IN SHARE MODE';
        }

        if ($platform instanceof PostgreSQLPlatform) {
            return 'FOR SHARE';
        }

        return $this->getWriteLockSQL($platform);
    }

    private function getWriteLockSQL(AbstractPlatform $platform): string
    {
        if ($platform instanceof DB2Platform) {
            return 'WITH RR USE AND KEEP UPDATE LOCKS';
        }

        if ($platform instanceof SqlitePlatform) {
            return '';
        }

        if ($platform instanceof SQLServerPlatform) {
            return '';
        }

        return 'FOR UPDATE';
    }
}
