<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Tools\Exception;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;

final class MissingColumnException extends ORMException
{
    public static function fromColumnSourceAndTarget(string $column, string $source, string $target): self
    {
        return new self(sprintf(
            'Column name "%s" referenced for relation from %s towards %s does not exist.',
            $column,
            $source,
            $target
        ));
    }
}
