<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Query\AST;

/**
 * DeleteStatement = DeleteClause [WhereClause]
 *
 * @link    www.doctrine-project.org
 */
class DeleteStatement extends Node
{
    /** @var DeleteClause */
    public $deleteClause;

    /** @var WhereClause|null */
    public $whereClause;

    /** @param DeleteClause $deleteClause */
    public function __construct($deleteClause)
    {
        $this->deleteClause = $deleteClause;
    }

    /**
     * {@inheritDoc}
     */
    public function dispatch($sqlWalker)
    {
        return $sqlWalker->walkDeleteStatement($this);
    }
}
