"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[624],{

/***/ 12795:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Code)
/* harmony export */ });
/* harmony import */ var _createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36861);
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Code = (0,_createLucideIcon_js__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)("Code", [
  ["polyline", { points: "16 18 22 12 16 6", key: "z7tu5w" }],
  ["polyline", { points: "8 6 2 12 8 18", key: "1eg1df" }]
]);


//# sourceMappingURL=code.js.map


/***/ }),

/***/ 20624:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailLayout)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/routing.tsx
var routing = __webpack_require__(41297);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__(94184);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
// EXTERNAL MODULE: ./node_modules/react-select/dist/react-select.esm.js + 49 modules
var react_select_esm = __webpack_require__(25990);
// EXTERNAL MODULE: ./node_modules/js-convert-case/index.js
var js_convert_case = __webpack_require__(24417);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
;// CONCATENATED MODULE: ./assets/src/js/react/components/ObjectSearch.tsx




/* harmony default export */ function ObjectSearch({ objectType, onChange, selected }) {
    const [timerNumber, setTimerNumber] = (0,external_React_.useState)(0);
    const [searchString, setSearchString] = (0,external_React_.useState)('');
    const { data: foundObjects, isLoading: isSearchLoading } = (0,datafetching_email/* useObjectSearch */.Iy)(objectType, searchString);
    (0,external_React_.useEffect)(() => {
        if (!foundObjects?.length) {
            return;
        }
        if (!selected) {
            onChange(foundObjects[0]);
        }
    }, [foundObjects]);
    (0,external_React_.useEffect)(() => {
        if (objectType) {
            onChange(null);
        }
    }, [objectType]);
    const searchObjects = (0,external_React_.useCallback)((inputValue) => {
        if (!inputValue?.length || !objectType) {
            return;
        }
        if (timerNumber) {
            clearTimeout(timerNumber);
        }
        setTimerNumber(window.setTimeout(() => {
            setSearchString(inputValue);
        }, 750));
    }, [timerNumber]);
    return external_React_default().createElement(react_select_esm/* default */.ZP, { isDisabled: !objectType, id: 'search-courses', placeholder: `Search ${(0,js_convert_case.toSentenceCase)(objectType)}...`, className: 'w-full', classNames: {
            control: () => '!rounded-md',
            input: () => '!mh-0'
        }, isSearchable: true, value: foundObjects?.find(opt => opt.value == selected) ?? null, onInputChange: searchObjects, isLoading: isSearchLoading, options: foundObjects, onChange: evt => onChange(evt) });
}

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailPreviewFrame.tsx



/* harmony default export */ function EmailPreviewFrame({ email, objectId }) {
    const { isLoading, isValidating, error, data } = (0,datafetching_email/* useEmailPreview */.Jz)(email?.id, objectId);
    return external_React_default().createElement("div", { className: 'flex-1 text-center relative' },
        (isLoading || isValidating) &&
            external_React_default().createElement("div", { className: 'absolute flex justify-center w-full h-full bg-black bg-opacity-20' },
                external_React_default().createElement(react.Spinner, { className: 'mt-2' })),
        error && external_React_default().createElement("div", null,
            "Error: ",
            error.message),
        external_React_default().createElement("iframe", { className: 'w-full h-full', srcDoc: data?.content }));
}

// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/createLucideIcon.js + 3 modules
var createLucideIcon = __webpack_require__(36861);
;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/refresh-cw.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const RefreshCw = (0,createLucideIcon/* default */.Z)("RefreshCw", [
  ["path", { d: "M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8", key: "v9h5vc" }],
  ["path", { d: "M21 3v5h-5", key: "1q7to0" }],
  ["path", { d: "M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16", key: "3uifl3" }],
  ["path", { d: "M8 16H3v5", key: "1cv678" }]
]);


//# sourceMappingURL=refresh-cw.js.map

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailPreview.tsx







function persistObjectSearch(objectType, id) {
    localStorage.setItem(`objectSearch-${objectType}`, id.toString());
}
function loadObjectSearch(objectType) {
    return objectType ? localStorage.getItem(`objectSearch-${objectType}`) : null;
}
/* harmony default export */ function EmailPreview({ email, className }) {
    const [selectedPreviewObject, setSelectedPreviewObject] = external_React_default().useState(loadObjectSearch(email.objectType));
    const onSetObjectSearch = (id) => {
        if (email && id) {
            persistObjectSearch(email.objectType, id);
        }
        setSelectedPreviewObject(id);
    };
    const { mutate } = (0,datafetching_email/* useEmailPreview */.Jz)(email.id, selectedPreviewObject);
    return (external_React_default().createElement("div", { className: classnames_default()(`flex flex-col h-full`, className) },
        external_React_default().createElement("div", { className: 'flex w-full items-center' },
            external_React_default().createElement(ObjectSearch, { objectType: email.objectType, onChange: opt => onSetObjectSearch(opt?.value ?? null), selected: selectedPreviewObject }),
            external_React_default().createElement(react.Button, { color: 'white', size: 'sm', onClick: () => mutate() },
                external_React_default().createElement(RefreshCw, { size: 16 }))),
        external_React_default().createElement(EmailPreviewFrame, { key: email.objectType, email: email, objectId: selectedPreviewObject })));
}

;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/settings.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Settings = (0,createLucideIcon/* default */.Z)("Settings", [
  [
    "path",
    {
      d: "M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.39a2 2 0 0 0-.73-2.73l-.15-.08a2 2 0 0 1-1-1.74v-.5a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z",
      key: "1qme2f"
    }
  ],
  ["circle", { cx: "12", cy: "12", r: "3", key: "1v7zrd" }]
]);


//# sourceMappingURL=settings.js.map

;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/eye.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Eye = (0,createLucideIcon/* default */.Z)("Eye", [
  ["path", { d: "M2 12s3-7 10-7 10 7 10 7-3 7-10 7-10-7-10-7Z", key: "rwhkz3" }],
  ["circle", { cx: "12", cy: "12", r: "3", key: "1v7zrd" }]
]);


//# sourceMappingURL=eye.js.map

// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/code.js
var code = __webpack_require__(12795);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/icons/paperclip.js
var paperclip = __webpack_require__(84617);
;// CONCATENATED MODULE: ./assets/src/js/react/layout/EmailLayout.tsx








/* harmony default export */ function EmailLayout() {
    const { email } = (0,dist/* useOutletContext */.bx)();
    const routeId = (0,routing/* useRouteId */.P)();
    const navigate = (0,dist/* useNavigate */.s0)();
    const [tab, setTab] = external_React_default().useState('config');
    const onClickTab = (value) => {
        navigate(`/${email.id}/${value}`);
    };
    return external_React_default().createElement((external_React_default()).Fragment, null,
        external_React_default().createElement(react.Tabs, { value: tab, className: '2xl:hidden' },
            external_React_default().createElement(react.TabsHeader, null,
                external_React_default().createElement(react.Tab, { value: 'config', onClick: () => setTab('config') },
                    external_React_default().createElement("div", { className: "flex items-center" },
                        external_React_default().createElement(Settings, { size: 16, className: "mr-1" }),
                        " Config")),
                external_React_default().createElement(react.Tab, { value: 'preview', onClick: () => setTab('preview') },
                    external_React_default().createElement("div", { className: "flex items-center" },
                        external_React_default().createElement(Eye, { size: 16, className: "mr-1" }),
                        " Preview")))),
        external_React_default().createElement("div", { className: 'flex h-full min-h-[80vh]' },
            external_React_default().createElement("div", { className: classnames_default()('2xl:w-full overflow-hidden transition-all duration-300 whitespace-nowrap', {
                    'w-full': tab === 'config',
                    'w-0': tab === 'preview'
                }) },
                external_React_default().createElement(react.Tabs, { value: routeId },
                    external_React_default().createElement(react.TabsHeader, null,
                        external_React_default().createElement(react.Tab, { value: 'sections', onClick: () => onClickTab('sections') },
                            external_React_default().createElement("div", { className: "flex items-center" },
                                external_React_default().createElement(code/* default */.Z, { size: 16, className: "mr-1" }),
                                " Sections")),
                        external_React_default().createElement(react.Tab, { value: 'attachments', onClick: () => onClickTab('attachments') },
                            external_React_default().createElement("div", { className: "flex items-center" },
                                external_React_default().createElement(paperclip/* default */.Z, { size: 16, className: "mr-1" }),
                                " Attachments")),
                        external_React_default().createElement(react.Tab, { value: 'settings', onClick: () => onClickTab('settings') },
                            external_React_default().createElement("div", { className: "flex items-center" },
                                external_React_default().createElement(Settings, { size: 16, className: "mr-1" }),
                                " Settings")))),
                external_React_default().createElement(dist/* Outlet */.j3, { context: { email } })),
            external_React_default().createElement("div", { className: classnames_default()('2xl:w-full overflow-hidden transition-all duration-300 whitespace-nowrap', {
                    'w-full': tab === 'preview',
                    'w-0': tab === 'config'
                }) },
                external_React_default().createElement(EmailPreview, { email: email }))));
}


/***/ })

}]);