<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'payment_tokens')]
class PaymentToken
{
    #[ORM\Id]
    #[ORM\Column(name: 'token_id', type: Types::BIGINT, options: ['unsigned' => true])]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'gateway_id', type: Types::STRING, length: 200, nullable: true, options: [])]
    private string $gatewayId;

    #[ORM\Column(name: 'token', type: Types::TEXT, nullable: true, options: [])]
    private string $token;

    #[ORM\Column(name: 'user_id', type: Types::BIGINT, nullable: true, options: ['unsigned' => true, 'default' => 0,])]
    private int $userId;

    #[ORM\Column(name: 'type', type: Types::STRING, length: 200, nullable: true, options: [])]
    private string $type;

    #[ORM\Column(name: 'is_default', type: Types::BOOLEAN, nullable: true, options: ['default' => false,])]
    private bool $isDefault;

    /**
     * @return int|null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int|null $id
     * @return PaymentToken
     */
    public function setId(?int $id): PaymentToken
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getGatewayId(): string
    {
        return $this->gatewayId;
    }

    /**
     * @param string $gatewayId
     * @return PaymentToken
     */
    public function setGatewayId(string $gatewayId): PaymentToken
    {
        $this->gatewayId = $gatewayId;
        return $this;
    }

    /**
     * @return string
     */
    public function getToken(): string
    {
        return $this->token;
    }

    /**
     * @param string $token
     * @return PaymentToken
     */
    public function setToken(string $token): PaymentToken
    {
        $this->token = $token;
        return $this;
    }

    /**
     * @return int
     */
    public function getUserId(): int
    {
        return $this->userId;
    }

    /**
     * @param int $userId
     * @return PaymentToken
     */
    public function setUserId(int $userId): PaymentToken
    {
        $this->userId = $userId;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return PaymentToken
     */
    public function setType(string $type): PaymentToken
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDefault(): bool
    {
        return $this->isDefault;
    }

    /**
     * @param bool $isDefault
     * @return PaymentToken
     */
    public function setIsDefault(bool $isDefault): PaymentToken
    {
        $this->isDefault = $isDefault;
        return $this;
    }

}