<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\Entity;

use DateTimeInterface;
use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping as ORM;
use WRCE\Dependencies\WordpressModels\ORM\Enum\LogSeverity;

/**
 * Abstract entity template to be extended for plugins
 */
abstract class AbstractLogEntity
{

    #[ORM\Column(name: 'id', type: Types::INTEGER)]
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'IDENTITY')]
    private ?int $id = null;

    #[ORM\Column(name: 'title', type: Types::STRING, length: 255)]
    private string $title;

    #[ORM\Column(name: 'message', type: Types::TEXT, length: 65535)]
    private string $message;

    #[ORM\Column(name: 'severity', type: Types::STRING, enumType: LogSeverity::class)]
    private LogSeverity $severity;

    #[ORM\Column(name: 'source', type: Types::STRING, length: 255)]
    private string $source;

    #[ORM\Column(name: 'category', type: Types::STRING, length: 255)]
    private string $category;

    #[ORM\Column(name: 'data', type: Types::JSON)]
    private array $data = [];

    #[ORM\Column(name: 'metadata', type: Types::JSON)]
    private array $metadata = [];

    #[ORM\Column(name: 'timestamp', type: Types::DATETIME_MUTABLE)]
    private DateTimeInterface $timestamp;

    public function getId(): ?int
    {
        return $this->id;
    }


    public function getTitle(): string
    {
        return $this->title;
    }

    public function setTitle(string $title): static
    {
        $this->title = $title;
        return $this;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function setMessage(string $message): static
    {
        $this->message = $message;
        return $this;
    }

    public function getSeverity(): LogSeverity
    {
        return $this->severity;
    }

    public function setSeverity(LogSeverity $severity): static
    {
        $this->severity = $severity;
        return $this;
    }

    public function getSource(): string
    {
        return $this->source;
    }

    public function setSource(string $source): static
    {
        $this->source = $source;
        return $this;
    }

    public function getCategory(): string
    {
        return $this->category;
    }

    public function setCategory(string $category): static
    {
        $this->category = $category;
        return $this;
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function setData(array $data): static
    {
        $this->data = $data;
        return $this;
    }

    public function getMetadata(): array
    {
        return $this->metadata;
    }

    public function setMetadata(array $metadata): static
    {
        $this->metadata = $metadata;
        return $this;
    }

    public function getTimestamp(): DateTimeInterface
    {
        return $this->timestamp;
    }

    public function setTimestamp(DateTimeInterface $timestamp): static
    {
        $this->timestamp = $timestamp;
        return $this;
    }

}