<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\DependencyInjection\CliCommandAttributes;

use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Action;

class WpCliCommandRegistry
{

    /**
     * @var array{
     *     name: string,
     *     callback: string,
     *     args: array
     * }[]
     */
    private array $commands = [];

    #[Action('cli_init')]
    public function initCommands()
    {
        foreach ($this->commands as $name => $command) {
            \WP_CLI::add_command($name, $command['callback'], $command['args']);
        }
    }

    public function addCommand(string $name, callable $callback, array $args)
    {
        $this->commands[$name] = [
            'callback' => $callback,
            'args' => $args,
        ];
    }

    /**
     * @return array
     */
    public function getCommands(): array
    {
        return $this->commands;
    }

}