<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */ declare(strict_types=1);

namespace WRCE\Dependencies\Jawira\CaseConverter\Glue;

/**
 * Class CobolCase
 *
 * Outputs string in _Cobol case_ format: THIS-IS-COBOL-CASE
 */
class CobolCase extends DashGluer
{
    /**
     * Format detected words in _Cobol case_
     *
     * @return string
     */
    public function glue(): string
    {
        return $this->glueUsingRules(self::DELIMITER, $this->upperCase);
    }
}
