<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Schema\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class TableDoesNotExist extends SchemaException
{
    public static function new(string $tableName): self
    {
        return new self(
            sprintf('There is no table with name "%s" in the schema.', $tableName),
            self::TABLE_DOESNT_EXIST,
        );
    }
}
