<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Driver\Mysqli\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Driver\AbstractException;

use function sprintf;

/**
 * @internal
 *
 * @psalm-immutable
 */
final class NonStreamResourceUsedAsLargeObject extends AbstractException
{
    public static function new(int $parameter): self
    {
        return new self(
            sprintf('The resource passed as a LARGE_OBJECT parameter #%d must be of type "stream"', $parameter),
        );
    }
}
