<?php

namespace RTMCustomMails\EmailSections\Defaults;

class CustomerNewAccountDefaultTemplate implements DefaultTemplateInterface
{

    /**
     * Returns the email id asociated with this template
     * @return string
     */
    public static function getEmailId(): string
    {
        return 'customer_new_account';
    }

    /**
     * Returns the default sections for this email
     * @return array EmailSection[]
     */
    public static function getDefaultSections(): array
    {
        return [
            [
                'id' => 'woocommerce_email_header',
                'enable' => true,
                'title' => 'Header',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 0,
            ],
            [
                'id' => 'greeting',
                'enable' => true,
                'title' => 'Greeting',
                'showTitle' => true,
                'text' => esc_html__('Hi {{ user_login }},', 'woocommerce'),
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => '',
                'enable' => true,
                'title' => 'Main Text',
                'showTitle' => true,
                'text' => <<<TWIG
Thanks for creating an account on {{ site_title }}. Your username is {{ user_login }}. You can access your account area to view orders, change your password, and more at: {{ woocommerce_my_account_url }}.
{% if is_password_generated %}
    {{ link(set_password_url, 'Click here to set your new password.') }}
{% endif %}
TWIG,
                'condition' => [],
                'sortOrder' => 2,
            ],
            [
                'id' => 'woocommerce_email_additional_content',
                'enable' => true,
                'title' => 'Additional Content',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 5,
            ],
            [
                'id' => 'woocommerce_email_footer',
                'enable' => true,
                'title' => 'Footer',
                'showTitle' => false,
                'text' => '',
                'condition' => [],
                'sortOrder' => 6,
            ]
        ];
    }
}
