<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\Timber\Cache;

use WRCE\Dependencies\Twig\CacheExtension\CacheStrategy\KeyGeneratorInterface;

class KeyGenerator implements KeyGeneratorInterface {

	/**
	 * @param mixed $value
	 * @return string
	 */
	public function generateKey( $value ) {
		if ( is_a($value, 'WRCE\Dependencies\Timber\Cache\TimberKeyGeneratorInterface') ) {
			return $value->_get_cache_key();
		}

		if ( is_array($value) && isset($value['_cache_key']) ) {
			return $value['_cache_key'];
		}

		$key = md5(json_encode($value));
		if ( is_object($value) ) {
			$key = get_class($value).'|'.$key;
		}

		return $key;
	}

}
