<?php
/*
 * Copyright (c) 2023. RTM Business
 *
 * @license proprietary
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\ORM\WooCommerceEntity;

use WRCE\Dependencies\Doctrine\DBAL\Types\Types;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Column;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Entity;
use WRCE\Dependencies\Doctrine\ORM\Mapping\GeneratedValue;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Id;
use WRCE\Dependencies\Doctrine\ORM\Mapping\Table;

#[Entity]
#[Table(name: 'admin_notes')]
class AdminNote
{
    #[Id]
    #[GeneratedValue(strategy: 'IDENTITY')]
    #[Column(name: 'note_id', type: Types::BIGINT, options: ['unsigned' => true])]
    private int $id;

    #[Column(name: 'name', type: Types::STRING, length: 255, nullable: false)]
    private string $name;

    #[Column(name: 'type', type: Types::STRING, length: 20, nullable: false)]
    private string $type;

    #[Column(name: 'locale', type: Types::STRING, length: 20, nullable: false)]
    private string $locale;

    #[Column(name: 'title', type: Types::TEXT, nullable: false)]
    private string $title;

    #[Column(name: 'content', type: Types::TEXT, nullable: false)]
    private string $content;

    #[Column(name: 'icon', type: Types::STRING, length: 200, nullable: false, options: ['default' => 'info'])]
    private string $icon;

    #[Column(name: 'content_data', type: Types::TEXT, nullable: true)]
    private ?string $contentData;

    #[Column(name: 'status', type: Types::STRING, length: 200, nullable: false)]
    private string $status;

    #[Column(name: 'source', type: Types::STRING, length: 200, nullable: false)]
    private string $source;

    #[Column(name: 'date_created', type: Types::DATETIME_MUTABLE, nullable: false, options: ['default' => '0000-00-00 00:00:00'])]
    private \DateTime $dateCreated;

    #[Column(name: 'date_reminder', type: Types::DATETIME_MUTABLE, nullable: true)]
    private ?\DateTime $dateReminder;

    #[Column(name: 'is_snoozable', type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    private bool $isSnoozable;

    #[Column(name: 'layout', type: Types::STRING, length: 20, nullable: false, options: ['default' => ''])]
    private string $layout;

    #[Column(name: 'image', type: Types::STRING, length: 200, nullable: true)]
    private ?string $image;

    #[Column(name: 'is_deleted', type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    private bool $isDeleted;

    #[Column(name: 'is_read', type: Types::BOOLEAN, nullable: false, options: ['default' => false])]
    private bool $isRead;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return AdminNote
     */
    public function setId(int $id): AdminNote
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return AdminNote
     */
    public function setName(string $name): AdminNote
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return AdminNote
     */
    public function setType(string $type): AdminNote
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @param string $locale
     * @return AdminNote
     */
    public function setLocale(string $locale): AdminNote
    {
        $this->locale = $locale;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return AdminNote
     */
    public function setTitle(string $title): AdminNote
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getContent(): string
    {
        return $this->content;
    }

    /**
     * @param string $content
     * @return AdminNote
     */
    public function setContent(string $content): AdminNote
    {
        $this->content = $content;
        return $this;
    }

    /**
     * @return string
     */
    public function getIcon(): string
    {
        return $this->icon;
    }

    /**
     * @param string $icon
     * @return AdminNote
     */
    public function setIcon(string $icon): AdminNote
    {
        $this->icon = $icon;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getContentData(): ?string
    {
        return $this->contentData;
    }

    /**
     * @param string|null $contentData
     * @return AdminNote
     */
    public function setContentData(?string $contentData): AdminNote
    {
        $this->contentData = $contentData;
        return $this;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return AdminNote
     */
    public function setStatus(string $status): AdminNote
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getSource(): string
    {
        return $this->source;
    }

    /**
     * @param string $source
     * @return AdminNote
     */
    public function setSource(string $source): AdminNote
    {
        $this->source = $source;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDateCreated(): \DateTime
    {
        return $this->dateCreated;
    }

    /**
     * @param \DateTime $dateCreated
     * @return AdminNote
     */
    public function setDateCreated(\DateTime $dateCreated): AdminNote
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getDateReminder(): ?\DateTime
    {
        return $this->dateReminder;
    }

    /**
     * @param \DateTime|null $dateReminder
     * @return AdminNote
     */
    public function setDateReminder(?\DateTime $dateReminder): AdminNote
    {
        $this->dateReminder = $dateReminder;
        return $this;
    }

    /**
     * @return bool
     */
    public function isSnoozable(): bool
    {
        return $this->isSnoozable;
    }

    /**
     * @param bool $isSnoozable
     * @return AdminNote
     */
    public function setIsSnoozable(bool $isSnoozable): AdminNote
    {
        $this->isSnoozable = $isSnoozable;
        return $this;
    }

    /**
     * @return string
     */
    public function getLayout(): string
    {
        return $this->layout;
    }

    /**
     * @param string $layout
     * @return AdminNote
     */
    public function setLayout(string $layout): AdminNote
    {
        $this->layout = $layout;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getImage(): ?string
    {
        return $this->image;
    }

    /**
     * @param string|null $image
     * @return AdminNote
     */
    public function setImage(?string $image): AdminNote
    {
        $this->image = $image;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted(): bool
    {
        return $this->isDeleted;
    }

    /**
     * @param bool $isDeleted
     * @return AdminNote
     */
    public function setIsDeleted(bool $isDeleted): AdminNote
    {
        $this->isDeleted = $isDeleted;
        return $this;
    }

    /**
     * @return bool
     */
    public function isRead(): bool
    {
        return $this->isRead;
    }

    /**
     * @param bool $isRead
     * @return AdminNote
     */
    public function setIsRead(bool $isRead): AdminNote
    {
        $this->isRead = $isRead;
        return $this;
    }


}