<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Tools;

use WRCE\Dependencies\Doctrine\ORM\Mapping\ClassMetadataFactory;
use WRCE\Dependencies\Doctrine\Persistence\Mapping\StaticReflectionService;

/**
 * The DisconnectedClassMetadataFactory is used to create ClassMetadataInfo objects
 * that do not require the entity class actually exist. This allows us to
 * load some mapping information and use it to do things like generate code
 * from the mapping information.
 *
 * @deprecated This class is being removed from the ORM and will be removed in 3.0.
 *
 * @link    www.doctrine-project.org
 */
class DisconnectedClassMetadataFactory extends ClassMetadataFactory
{
    /** @return StaticReflectionService */
    public function getReflectionService()
    {
        return new StaticReflectionService();
    }
}
