<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Persisters;

use WRCE\Dependencies\Doctrine\ORM\Exception\PersisterException;

use function sprintf;

final class MatchingAssociationFieldRequiresObject extends PersisterException
{
    public static function fromClassAndAssociation(string $class, string $associationName): self
    {
        return new self(sprintf(
            'Cannot match on %s::%s with a non-object value. Matching objects by id is ' .
            'not compatible with matching on an in-memory collection, which compares objects by reference.',
            $class,
            $associationName
        ));
    }
}
