<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Mapping\Exception;

use WRCE\Dependencies\Doctrine\ORM\Exception\ORMException;

use function sprintf;
use function var_export;

final class InvalidCustomGenerator extends ORMException
{
    public static function onClassNotConfigured(): self
    {
        return new self('Cannot instantiate custom generator, no class has been defined');
    }

    /** @param mixed[] $definition */
    public static function onMissingClass(array $definition): self
    {
        return new self(sprintf(
            'Cannot instantiate custom generator : %s',
            var_export($definition, true)
        ));
    }
}
