<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\ORM\Cache\Exception;

use function sprintf;

class NonCacheableEntity extends CacheException
{
    public static function fromEntity(string $entityName): self
    {
        return new self(sprintf(
            'Entity "%s" not configured as part of the second-level cache.',
            $entityName
        ));
    }
}
