<?php

namespace RTMCustomMails\Email;

use WRCE\Dependencies\Doctrine\ORM\EntityManagerInterface;
use RTMCustomMails\Database\Entity\Email;
use RTMCustomMails\Migrations;
use WC_Email;
use WRCE\Dependencies\WordpressModels\DependencyInjection\HookAttributes\Attributes\Filter;

class EmailClassesService
{
    /**
     * @param array<string, WC_Email> $classes
     * @return array<string, WC_Email>
     */
    #[Filter('woocommerce_email_classes', accepted_args: 1)]
    public function addEmailsFromDb(array $classes, EntityManagerInterface $entityManager, Migrations $migrations)
    {
        if (!$migrations->isFullyMigrated()) {
            return $classes;
        }
        // get all emails from db
        /** @var Email[] $emailEntities */
        $emailEntities = $entityManager->getRepository(Email::class)->findAll();
        foreach ($emailEntities as $entity) {
            $dynamicEmail = new DynamicEmail($entity);
            $classes[$dynamicEmail->id] = $dynamicEmail;
        }
        return $classes;
    }
}
