<?php

namespace RTMCustomMails\Email;

use RTMCustomMails\Database\Entity\Email;
use RTMCustomMails\Preview\EmailObjects;

class DynamicEmail extends RTMCustomEmail
{
    private Email $emailEntity;

    public function __construct(Email $emailEntity)
    {
        $this->emailEntity = $emailEntity;
        $this->id = $emailEntity->getId();
        $this->title = $emailEntity->getTitle();
        $this->heading = $emailEntity->getHeading();
        $this->description = $emailEntity->getDescription();
        $this->subject = $emailEntity->getSubject();
        $this->object_type = $emailEntity->getObjectType();
        $this->recipient_type = $emailEntity->getRecipientType();
        parent::__construct();
    }

    public function trigger($object_id = null)
    {
        $this->setup_locale();

        $supportedObjects = EmailObjects::instance()->getSupported();
        $objectSupport = $supportedObjects[$this->object_type];

        // Get the object instance by ID
        $this->object = $objectSupport->getObjectById($object_id);

        if ($this->object) {
            // Get the recipient based on the object
            $recipient = $objectSupport->getRecipientByObject($this->object, $this->recipient_type);
            if ($this->is_enabled() && $recipient) {
                $this->send($recipient, $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments());
            }
        }
        $this->restore_locale();

    }

    public function getTriggerHooks(): array
    {
        return [];
    }
}
