"use strict";
(self["webpackChunkwoocommerce_rtm_custom_emails"] = self["webpackChunkwoocommerce_rtm_custom_emails"] || []).push([[664],{

/***/ 1664:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ EmailSettingsRoute)
});

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__(99196);
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);
// EXTERNAL MODULE: ./node_modules/react-router/dist/index.js
var dist = __webpack_require__(89250);
// EXTERNAL MODULE: ./assets/src/js/react/lib/datafetching/email.ts
var datafetching_email = __webpack_require__(21954);
// EXTERNAL MODULE: ./assets/src/js/react/lib/rjsf/SchemaForm/index.tsx + 28 modules
var SchemaForm = __webpack_require__(1172);
;// CONCATENATED MODULE: ./assets/src/js/schema/settings.uiSchema.json
const settings_uiSchema_namespaceObject = JSON.parse('{"ui:submitButtonOptions":{"props":{"className":"self-end"}},"trigger_hooks":{"ui:widget":"multiselect"}}');
// EXTERNAL MODULE: ./node_modules/@material-tailwind/react/index.js
var react = __webpack_require__(59335);
// EXTERNAL MODULE: ./assets/src/js/react/lib/actions/email.ts
var actions_email = __webpack_require__(72926);
// EXTERNAL MODULE: ./node_modules/lucide-react/dist/esm/createLucideIcon.js + 3 modules
var createLucideIcon = __webpack_require__(36861);
;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/upload.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Upload = (0,createLucideIcon/* default */.Z)("Upload", [
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["polyline", { points: "17 8 12 3 7 8", key: "t8dd8p" }],
  ["line", { x1: "12", x2: "12", y1: "3", y2: "15", key: "widbto" }]
]);


//# sourceMappingURL=upload.js.map

;// CONCATENATED MODULE: ./node_modules/lucide-react/dist/esm/icons/download.js
/**
 * @license lucide-react v0.394.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */



const Download = (0,createLucideIcon/* default */.Z)("Download", [
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["polyline", { points: "7 10 12 15 17 10", key: "2ggqvy" }],
  ["line", { x1: "12", x2: "12", y1: "15", y2: "3", key: "1vk2je" }]
]);


//# sourceMappingURL=download.js.map

;// CONCATENATED MODULE: ./assets/src/js/react/components/DeleteEmailModal.tsx


function DeleteEmailModal({ show, onClose, onConfirm, loading }) {
    if (!show) {
        return null;
    }
    return (external_React_default().createElement("div", { className: "fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50" },
        external_React_default().createElement("div", { className: "bg-white p-6 rounded-lg" },
            external_React_default().createElement("h2", { className: "text-lg font-semibold mb-4" }, "Are you sure you want to delete this email?"),
            external_React_default().createElement("div", { className: "flex justify-center" },
                external_React_default().createElement(react.Button, { onClick: onClose, className: "mr-2 border border-gray-200 bg-gray-300", disabled: loading }, "Cancel"),
                external_React_default().createElement(react.Button, { onClick: onConfirm, className: "border border-gray-200 bg-red-500 text-white", disabled: loading }, loading ? external_React_default().createElement(react.Spinner, { className: "w-4 h-4" }) : 'Delete')))));
}
/* harmony default export */ const components_DeleteEmailModal = (DeleteEmailModal);

;// CONCATENATED MODULE: ./assets/src/js/react/components/EmailSettings.tsx









const { toast } = window;
const isEmptyValue = (value) => {
    return !value
        || (Array.isArray(value) && value.length === 0)
        || (typeof value === 'object' && Object.keys(value).length === 0)
        || value === '';
};
function EmailSettings({ email, onEmailUpdated, disabled = false }) {
    const mutate = (0,datafetching_email/* useEmailMutate */.FX)();
    const [submitting, setSubmitting] = external_React_default().useState(false);
    const { data: schema, isLoading: isLoadingSchema } = (0,datafetching_email/* useEmailSettingsSchema */.J$)(email);
    const [exporting, setExporting] = external_React_default().useState(false);
    const [importing, setImporting] = external_React_default().useState(false);
    const importRef = external_React_default().useRef(null);
    const [settings, setSettings] = external_React_default().useState(email.settings ?? {});
    const [showModal, setShowModal] = external_React_default().useState(false);
    const [deleting, setDeleting] = external_React_default().useState(false);
    const navigate = (0,dist/* useNavigate */.s0)();
    const saveSettings = (data) => {
        setSubmitting(true);
        (0,actions_email/* saveEmail */.it)({ ...email, settings: data })
            .catch((error) => {
            toast.error('Error saving email sections: ' + error.message);
        })
            .then((email) => {
            toast.success('Email sections saved', { duration: 3000 });
            onEmailUpdated(email);
        })
            .finally(() => setSubmitting(false));
    };
    const exportSettings = () => {
        setExporting(true);
        (0,actions_email/* exportEmail */.Cu)(email)
            .then(response => {
            const a = document.createElement("a");
            const file = new Blob([JSON.stringify(response)], { type: 'text/plain' });
            a.href = URL.createObjectURL(file);
            a.download = 'export-' + email.id + '.json';
            a.click();
        })
            .catch(err => toast.error(`Error exporting email settings: ${err.message}`))
            .finally(() => setExporting(false));
    };
    const importSettings = () => {
        setImporting(true);
        const response = confirm("Importing email settings will overwrite your current settings. Make sure you have a backup of your current settings. Do you want to continue?");
        if (!response) {
            setImporting(false);
            return;
        }
        importRef.current?.click();
    };
    const onFileInput = (0,external_React_.useCallback)((e) => {
        const file = e.target.files?.[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = (evt) => {
                const content = evt.target?.result;
                try {
                    const data = JSON.parse(content);
                    (0,actions_email/* importEmail */.KH)(email, data)
                        .then((email) => mutate(email))
                        .catch((error) => toast.error('Error importing email settings: ' + error.message))
                        .finally(() => setImporting(false));
                }
                catch (e) {
                    toast.error('Error reading file: ' + (e instanceof Error ? e.message : 'Unknown error'));
                }
            };
            reader.readAsText(file);
        }
    }, [email]);
    const suppressEmptyOptionalObjectError = (0,external_React_.useCallback)((errors) => {
        function shouldSuppressError(formData, error) {
            if (error.name === 'required' && error.property) {
                const parentFieldId = error.property
                    .replace(`['${error.params.missingProperty}']`, '')
                    .replace("['", '')
                    .replace("']", '');
                const parentFieldValue = formData[parentFieldId];
                return Boolean(parentFieldId) && JSON.stringify(parentFieldValue) === '{}';
            }
            if (error.property && isEmptyValue(settings[error.property])) {
                return true;
            }
            return false;
        }
        return errors.filter(error => !shouldSuppressError(settings, error));
    }, [settings]);
    const handleDelete = () => {
        setShowModal(true);
    };
    const confirmDelete = () => {
        setSubmitting(true);
        setDeleting(true);
        (0,actions_email/* deleteEmail */.nd)(email.id)
            .then(() => {
            toast.success('Email deleted successfully', { duration: 3000 });
            onEmailUpdated(email);
            navigate('/');
        })
            .catch((error) => {
            toast.error('Error deleting email: ' + error.message);
        })
            .finally(() => {
            setSubmitting(false);
            setDeleting(false);
            setShowModal(false);
        });
    };
    const handleDynamicSettings = () => {
        navigate(`/${email.id}/dynamic-settings`);
    };
    return (external_React_default().createElement((external_React_default()).Fragment, null,
        isLoadingSchema && external_React_default().createElement("div", { className: 'flex justify-center mb-2' },
            external_React_default().createElement(react.Spinner, null)),
        external_React_default().createElement(SchemaForm/* default */.Z, { disabled: disabled || isLoadingSchema || submitting, schema: schema ?? {}, uiSchema: settings_uiSchema_namespaceObject, data: settings, transformErrors: suppressEmptyOptionalObjectError, onSubmit: saveSettings, onChange: ({ formData }) => {
                setSettings(formData);
            }, submitLabel: submitting ? 'Saving...' : 'Save' }),
        external_React_default().createElement(react.ButtonGroup, { size: 'sm', color: 'white', fullWidth: true, className: 'mt-2' },
            external_React_default().createElement(react.Button, { onClick: importSettings, className: 'border border-gray-200 inline-flex justify-center', disabled: importing },
                external_React_default().createElement(Upload, { className: 'pr-1', size: 16 }),
                importing ? external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }) : 'Import'),
            external_React_default().createElement(react.Button, { onClick: exportSettings, className: 'border border-gray-200 inline-flex justify-center', disabled: exporting },
                external_React_default().createElement(Download, { className: 'pr-1', size: 16 }),
                exporting ? external_React_default().createElement(react.Spinner, { className: 'w-4 h-4 pr-1' }) : 'Export')),
        email.isDynamic && (external_React_default().createElement(react.ButtonGroup, { size: 'sm', color: 'white', fullWidth: true, className: 'mt-2' },
            external_React_default().createElement(react.Button, { onClick: handleDelete, className: 'border border-gray-200 inline-flex justify-center bg-red-500 text-white', disabled: submitting }, "Delete"),
            external_React_default().createElement(react.Button, { onClick: handleDynamicSettings, className: 'border border-gray-200 inline-flex justify-center bg-blue-500 text-white', disabled: submitting }, "Dynamic settings"))),
        external_React_default().createElement("input", { type: 'file', accept: 'application/json', className: 'hidden', onInput: onFileInput, ref: importRef }),
        external_React_default().createElement(components_DeleteEmailModal, { show: showModal, onClose: () => setShowModal(false), onConfirm: confirmDelete, loading: deleting })));
}
/* harmony default export */ const components_EmailSettings = (EmailSettings);

;// CONCATENATED MODULE: ./assets/src/js/react/routes/EmailSettingsRoute.tsx




/* harmony default export */ function EmailSettingsRoute() {
    const revalidateAll = (0,datafetching_email/* useEmailsMutate */.zv)();
    const ctx = (0,dist/* useOutletContext */.bx)();
    const onUpdated = () => {
        revalidateAll();
    };
    return external_React_default().createElement(components_EmailSettings, { key: ctx.email.id, email: ctx.email, onEmailUpdated: onUpdated });
}


/***/ })

}]);