<?php
/**
 * @license proprietary
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

namespace WRCE\Dependencies\WordpressModels\Rest\Permissions;

use WRCE\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunction;
use WRCE\Dependencies\Symfony\Component\ExpressionLanguage\ExpressionFunctionProviderInterface;

class AuthorizationExpressionFunctionProvider implements ExpressionFunctionProviderInterface
{

    public function __construct(private readonly PermissionFunctionsInterface $permissionFunctions)
    {
    }

    public function compileIsLoggedIn(): string
    {
        $class = $this->permissionFunctions::class;
        return "$class::isAuthorized()";
    }

    public function evaluateisLoggedIn(): bool
    {
        return $this->permissionFunctions::isAuthorized();
    }

    public function getFunctions(): array
    {
        return [
            new ExpressionFunction('is_authorized',
                $this->compileIsLoggedIn(...),
                $this->evaluateisLoggedIn(...)),
        ];
    }
}