<?php
/**
 * @license MIT
 *
 * Modified by Beau Fiechter on 14-June-2024 using {@see https://github.com/BrianHenryIE/strauss}.
 */

declare(strict_types=1);

namespace WRCE\Dependencies\Doctrine\DBAL\Schema\Exception;

use WRCE\Dependencies\Doctrine\DBAL\Schema\SchemaException;

use function sprintf;

/** @psalm-immutable */
final class ColumnAlreadyExists extends SchemaException
{
    public static function new(string $tableName, string $columnName): self
    {
        return new self(
            sprintf('The column "%s" on table "%s" already exists.', $columnName, $tableName),
            self::COLUMN_ALREADY_EXISTS,
        );
    }
}
