<?php

namespace RTMCustomMails\Preview;

use RTMCustomMails\ObjectSupport\EmailObjectSupport;
use RTMCustomMails\ObjectSupport\EmailOrderSupport;
use RTMCustomMails\ObjectSupport\EmailUserSupport;
use WRCE\Dependencies\WordpressModels\Traits\SingletonTrait;

class EmailObjects
{

    use SingletonTrait;

    /**
     * @param EmailObjectSupport[] $supported
     */
    public function __construct(private array $supported = [])
    {
        add_action('init', [$this, 'applyRegisteredObjectSupport']);
//        add_action('wrce_object_types_registered', [$this, 'registerObjectConditionFunctions']);

        add_filter('wrce_register_object_preview_support', [$this, 'addDefaultObjectSupport']);
    }

    public function addDefaultObjectSupport(array $supported): array
    {
        return array_reduce(
            [EmailOrderSupport::instance(), EmailUserSupport::instance()],
            function ($carry, EmailObjectSupport $support) {
                $carry[$support->getObjectType()] = $support;
                return $carry;
            },
            $supported
        );
    }

    public function applyRegisteredObjectSupport(): void
    {
        $this->supported = apply_filters('wrce_register_object_preview_support', []);

        do_action('wrce_object_types_registered', $this->supported);
    }

    /**
     * @return array<string, EmailObjectSupport>
     */
    public function getSupported(): array
    {
        return $this->supported;
    }


}